<?php

function gettemplate($templatename,$escape=1,$gethtmlcomments=1) {
  // gets a template from the db or from the local cache
  global $templatecache,$templatesetid,$addtemplatename,$website_template_path;
  //echo "Getting $templatename\n";
  if (isset($templatecache[$templatename])) {
    $template=$templatecache[$templatename];
  } else {
    //echo "$website_template_path/$templatename.tpl<br>";
    $template = implode("",file("$website_template_path/$templatename.tpl"));
    $template = preg_replace("/\[TEMPLATE\](.+?)\[\/TEMPLATE\]/e", "getnestedtemplate('\\1')", $template); // Any Nested Templates???
    //echo $template;
    $templatecache[$templatename]=$template;
 }

  if ($escape==1) {
    $template=addslashes($template);
    $template=str_replace("\\'","'",$template);
  }
  if ($gethtmlcomments and $addtemplatename) {
    return "<!-- BEGIN TEMPLATE: $templatename -->\n$template\n<!-- END TEMPLATE: $templatename -->";
  }
  return $template;
}

function getnestedtemplate($templatename)
{
  $new_data = gettemplate($templatename,0,0);
  return $new_data;
}


// ###################### Start dooutput #######################
function dooutput($vartext,$sendheader=1) {

  global $pagestarttime,$query_count,$showqueries,$querytime;

  if ($showqueries) {
    $pageendtime=microtime();

    $starttime=explode(" ",$pagestarttime);
    $endtime=explode(" ",$pageendtime);

    $totaltime=$endtime[0]-$starttime[0]+$endtime[1]-$starttime[1];

    $vartext.="<!-- Page generated in $totaltime seconds with $query_count queries -->";
  }

  if (!$showqueries) {
    echo dovars($vartext,$sendheader);
    flush;
  } else {
    $output=dovars($vartext,$sendheader);
    echo "\n<b>Page generated in $totaltime seconds with $query_count queries,\nspending $querytime doing MySQL queries and ".($totaltime-$querytime)." doing PHP things.</b></pre>";
    flush;
  }
}

// ###################### Start dovars #######################
function dovars($newtext,$sendheader=1) {
  // parses replacement vars

  global $replacementsetid,$gzipoutput,$gziplevel,$newpmmsg;
  static $vars;

  if (connection_status()) {
    exit;
  }

  global $PHP_SELF;

  if ($gzipoutput and !headers_sent()) {
    $newtext=gzipoutput($newtext,$gziplevel);
  }

  if ($sendheader) {
    @header("Content-Length: ".strlen($newtext));
  }

  return $newtext;
}


function sql_safe($a_string)
{
  $magic_quotes_active = get_magic_quotes_gpc();
  if ($magic_quotes_active) 
  {
    $a_string = stripslashes($a_string);
  }
  $a_string = htmlspecialchars($a_string, ENT_QUOTES);
  $a_string = mysql_real_escape_string($a_string);
  return $a_string;  
}



?>
